/******************* FormatRSKeys.rexx *******************/
/*                                                       */
/*             Copyright 1994 by Dave Senger             */
/*                                                       */
/*                      Aug. 25/94                       */
/*                                                       */
/*   Please keep my name, this notice, and all comments, */
/* intact in any distribution of this program.           */
/*                                                       */
/*   This ARexx script edits the output of the ReSource  */
/* utility, ShowKeys, in RAM:RSKeys, to RAM:ERSKeys so   */
/* that the title line and following blank line are      */
/* removed, if necessary.  Next, the script reformats    */
/* RAM:ERSKeys to RAM:RFRSKeys, so that the menu items & */ 
/* subitems precede the keys, depositing the result in   */
/* RAM:RFRSKeys.  RAM:RFRSKeys is then sorted, using the */
/* C directory command, `SORT', to produce a file,       */
/* RAM:SRFRSKeys, with the menu items alphabetically     */
/* ordered.  Any of these files can then be printed.     */
/*                                                       */
/*********************************************************/


/**********************  U S A G E  **********************/
/*                                                       */
/*   Assuming that ARexx is properly set up on your      */
/* system, and that this script is in your Rexxc         */
/* directory, CD a Shell to the directory containing     */
/* the ReSource utility, `ShowKeys', and enter:          */
/*                                                       */
/*                    rx FormatRSKeys                    */
/*                                                       */
/*********************************************************/


IF ~EXISTS('ShowKeys') THEN DO
   SAY
   SAY "   Can't find `ShowKeys'.  Wrong directory??"
   SAY "   CD a Shell to the directory containing the ReSource utility,"
   SAY "`ShowKeys', and try again."
   EXIT 20     /* Quit */
   END

SAY
SAY "     If you are using ShowKeys from ReSource V5.10, `RS.Keytable'"
SAY "must be in your S directory.  With ShowKeys V3.01, which comes"
SAY "with ReSource V6.01, `RS.Keytable' can also be in your current"
SAY "directory."
SAY
SAY "       >>>>> Copying ReSource Key Bindings.  Please wait -- <<<<<"

ADDRESS COMMAND 'ShowKeys >RAM:RSKeys'  /* Original ReSource Key Bindings */

IF ~EXISTS('RAM:RSKeys') THEN DO        /* Did ShowKeys generate file??  */
   SAY "Can't find file `RAM:RSKeys'.  Sorry, no can do!"
   EXIT 20     /* Quit */
   END

x=OPEN('infile','RAM:RSKeys')          /* Open specified file */

SAY
SAY "                >>>>> Editing Key Bindings File.  <<<<<"

x=OPEN('newfile','RAM:ERSKeys','write') /* Edited file */

line=READLN('infile')
PARSE VAR line x .
IF UPPER(x)~='SHOWKEYS' & LENGTH(line)>0 THEN x=WRITELN('newfile',line)
DO UNTIL EOF('infile')
   line=READLN('infile')
   IF LENGTH(line)>0 THEN x=WRITELN('newfile',line)
   END

x=CLOSE('infile')
x=CLOSE('newfile')                       /* Reset file pointer */
x=OPEN('newfile','RAM:ERSKeys')
x=OPEN('outfile','RAM:RFRSKeys','write') /* Reformatted file */

SAY
SAY "                >>>>> Reformatting Edited File.  <<<<<"

DO UNTIL EOF('newfile')
   inline=READLN('newfile')
   IF LENGTH(inline)>0 THEN DO
      PARSE VAR inline outline '_' inline
      inline=STRIP(inline,,' _')         /* Strip spaces & underlines */
      outline=SUBSTR(inline,1,55,'_')||outline
      x=WRITELN('outfile',outline)       /* Increase or reduce `55' to -- */
      END                                /* -- lengthen or shorten lines */
   END

x=CLOSE('newfile')
x=CLOSE('outfile')

SAY
SAY "                >>>>> Sorting Reformatted File.  <<<<<"

ADDRESS COMMAND 'Sort RAM:RFRSKeys To RAM:SRFRSKeys'

SAY
SAY
SAY "                          Original  Edited   Reformatted Sorted"
/* SAY */
SAY "You can read or print files RSKeys, ERSKeys, RFRSKeys, & SRFRSKeys in RAM:."
SAY
SAY "That gets it.  So long!"

EXIT 0
